from bpy.types import PropertyGroup
from bpy.props import EnumProperty, BoolProperty, StringProperty, FloatVectorProperty, FloatProperty
# from ...addon.naming import FluidLabNaming
# from ...addon.paths import FluidLabPaths


class FluidLab_PG_Rendering(PropertyGroup):


    ##########################
    """ Rendering Viewport """
    ##########################

    # Para guardar los settings del usuario antes de hacerle Pretty Viewport:
    viewport_switched: BoolProperty(default=False)
    last_show_overlays: BoolProperty(default=True)
    last_background_type: StringProperty(default='THEME')
    last_background_color: FloatVectorProperty(default=(0.0, 0.0, 0.0))
    last_light_type: StringProperty(default='STUDIO')
    last_color_type: StringProperty(default='MATERIAL')
    last_show_cavity: BoolProperty(default=False)
    last_cavity_type: StringProperty(default='SCREEN')
    last_cavity_ridge_factor: FloatProperty(default=1)
    last_curvature_ridge_factor: FloatProperty(default=1)
    last_cavity_valley_factor: FloatProperty(default=1)
    last_curvature_valley_factor: FloatProperty(default=1)
    last_show_shadows: BoolProperty(default=False)

    ########################################################################################
    # Para simplificar las opciones de render, tuve que recrear algunos elementos de blender
    # como el file_format y el container

    def bt_percentages_update(self, context):
        scn = context.scene
        render = scn.render

        if self.bt_percentages == 'TWENTY_FIVE':
            render.resolution_percentage = 25
        if self.bt_percentages == 'FIFTY':
            render.resolution_percentage = 50
        if self.bt_percentages == 'SEVENTY_FIVE':
            render.resolution_percentage = 75
        if self.bt_percentages == 'FULL':
            render.resolution_percentage = 100

    bt_percentages: EnumProperty(
        name="Percentages",
        items=(
            ('TWENTY_FIVE',     "25%",      "", 0),
            ('FIFTY',           "50%",      "", 1),
            ('SEVENTY_FIVE',    "75%",      "", 2),
            ('FULL',            "100%",     "", 3),
        ),
        default='FULL',
        update=bt_percentages_update
    )

    def file_format_update(self, context):
        scn = context.scene
        render = scn.render
        render.image_settings.file_format = self.file_format

    file_format: EnumProperty(
        name="File Format",
        items=(
            ("", "Image", ""),
            ('BMP',                     'BMP',                  "", 0),
            ('IRIS',                    "Iris",                 "", 1),
            ('PNG',                     "Png",                  "", 2),
            ('JPEG',                    'JPEG',                 "", 3),
            ('JPEG2000',                "JPEG 2000",            "", 4),
            ('TARGA',                   "Targa",                "", 5),
            ('TARGA_RAW',               "Targa Raw",            "", 6),
            ("", "", ""),
            ('CINEON',                  "Cineon",               "", 7),
            ('DPX',                     'DPX',                  "", 8),
            ('OPEN_EXR_MULTILAYER',     "OpenEXR Multilayer",   "", 9),
            ('OPEN_EXR',                "OpenEXR",              "", 10),
            ('HDR',                     'HDR',                  "", 11),
            ('TIFF',                    'TIFF',                 "", 12),
            ('WEBP',                    "WebP",                 "", 13),
            ("", "Movie", ""),
            ('AVI_JPEG',                "AVI JPEG",             "", 14),
            ('AVI_RAW',                 "AVI Raw",              "", 15),
            ('FFMPEG',                  "FFmpeg Video",         "", 16),
        ),
        default='PNG',
        update=file_format_update
    )

    def container_update(self, context):
        scn = context.scene
        render = scn.render
        render.ffmpeg.format = self.container

    container: EnumProperty(
        name="Container",
        items=(
            ('MPEG1',       "MPEG-1",       "", 0),
            ('MPEG2',       "MPEG-2",       "", 1),
            ('MPEG4',       "MPEG-4",       "", 2),
            ('AVI',         'AVI',          "", 3),
            ('QUICKTIME',   "QuickTime",    "", 4),
            ('DV',          'DV',           "", 5),
            ('OGG',         "Ogg",          "", 6),
            ('MKV',         "Matroska",     "", 7),
            ('FLASH',       "Flash",        "", 8),
            ('WEBM',        "WebM",         "", 9),
        ),
        default='MKV',
        update=container_update
    )
    # fin, simplificacion de rendering
    ########################################################################################